Imports font_substitution.DynaPDF

Module Module1

   ' Error callback function.
   ' If the function name should not appear at the beginning of the error message then set
   ' the flag emNoFuncNames (pdf.SetErrorMode(CPDF.TErrMode.emNoFuncNames)).
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.WriteLine("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function

   Function GetFileBuffer(ByVal FileName As String) As String
      Dim f As System.IO.FileStream = New System.IO.FileStream(FileName, System.IO.FileMode.Open, System.IO.FileAccess.Read)
      Dim b As System.IO.BinaryReader = New System.IO.BinaryReader(f, System.Text.Encoding.Unicode)
      Dim buffer As Char()
      ReDim buffer(f.Length - 1)
      b.Read(buffer, 0, f.Length)
      f.Close()
      Return buffer
   End Function

   Sub Main()
      Try
         Dim pdf As CPDF = New CPDF()
         ' You can either use events or declare a callback function.
         pdf.SetOnErrorProc(AddressOf PDFError)
         pdf.CreateNewPDF(Nothing) ' We do not create a PDF file in this example

            pdf.SetPageCoords(TPageCoord.pcTopDown)

            ' Enable complex text layout
            pdf.SetGStateFlags(TGStateFlags.gfComplexText, False)

            Dim txt As String = GetFileBuffer("../../../../test_files/multi_lang.txt")

            pdf.Append()
               ' The font must be loaded with cpUnicode.
               pdf.SetFont("Arial", TFStyle.fsRegular, 10.0, True, TCodepage.cpUnicode)
               pdf.SetLeading(pdf.GetTypoLeading())
               pdf.WriteFTextEx(50.0, 50.0, pdf.GetPageWidth() - 100.0, pdf.GetPageHeight() - 100.0, TTextAlign.taJustify, txt)
            pdf.EndPage()
         ' No fatal error occurred?
         If pdf.HaveOpenDoc() Then
            ' We write the output file into the current directory.
            Dim filePath As String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"
            If pdf.OpenOutputFile(filePath) Then
               If pdf.CloseFile() Then
                  Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
                  p.StartInfo.FileName = filePath
                  p.Start()
               End If
            End If
         End If
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
         Console.Read()
      End Try
   End Sub

End Module
